import mido
import subprocess
import time

PORT_NAME = 'KaraokeControl'
SINK_NAME = 'BG_Music_Sink'

def setup_virtual_sink():
    """Luo virtuaalisen äänikaapelin taustamusiikille."""
    print("Varmistetaan virtuaalikaapelin olemassaolo...")
    # Yritetään ladata null-sink (virtuaalikaapeli). Jos se on jo olemassa, sittenpähän on. Kaikki OK.
    cmd = [
        'pactl', 'load-module', 'module-null-sink',
        f'sink_name={SINK_NAME}',
        'sink_properties=device.description=BG_MUSIC_ROUTER'
    ]
    subprocess.run(cmd, capture_output=True)

def set_bg_volume(volume_percent):
    """Säätää vain taustamusiikkikaapelin volyymia."""
    # Varmistetaan, ettei volyymi mene yli 100%
    vol = max(0, min(100, volume_percent))
    subprocess.run(['pactl', 'set-sink-volume', SINK_NAME, f'{vol}%'])

def main():
    setup_virtual_sink()
    
    print(f"Luodaan virtuaalinen MIDI-portti: {PORT_NAME}...")
    try:
        with mido.open_input(PORT_NAME, virtual=True) as port:
            print("Daemon käynnissä ja odottaa MIDI-komentoja selaajalta...")
            for msg in port:
                if msg.type == 'control_change':
                    # CC17: Taustamusiikin fader (0-127 -> 0-100%)
                    if msg.control == 17:
                        vol_pct = int((msg.value / 127.0) * 100)
                        set_bg_volume(vol_pct)
    except Exception as e:
        print(f"Virhe MIDI-yhteydessä: {e}")
        time.sleep(5) # Odotetaan hetki ennen kaatumista, jotta systemd voi yrittää uudelleen

if __name__ == '__main__':
    main()
